/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CommonSystem {
    public static final int LOCATION_OTHER = 0;
    public static final int LOCATION_SERVER = 1;
    public static final int LOCATION_CLIENT = 2;
    public static final int LOCATION_UNIFIED = 3;
    private static CommonSystem system = new CommonSystem();
    private int location = 1;
    private boolean usingHTML;
    public static final boolean IS_DEVELOPMENT_ENVIRONMENT = true;
    private String _host = "localhost";
    private boolean clientOnServerMachine = false;
    private boolean isCimom = false;
    private static final String TRACE_MASKT = "XFRMCSYT";
    private static final String TRACE_MASKF = "XFRMCSYF";
    private static final String TRACE_MASKD = "XFRMCSYD";

    protected CommonSystem() {
    }

    public static CommonSystem getCommonSystem() {
        return system;
    }

    public UserContext getSystemUserContext() {
        return UserContext.getCurrentUserContext();
    }

    public void setSystemUserContext(UserContext uc) {
        uc.attachToThread();
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public boolean isLocationClient() {
        return this.location == 2;
    }

    public boolean isLocationServer() {
        return this.location == 1;
    }

    public boolean isLocationUnified() {
        return this.location == 3;
    }

    public void setClientOnServerMachine(boolean bSame) {
        this.clientOnServerMachine = bSame;
    }

    public boolean isClientOnServerMachine() {
        return this.clientOnServerMachine;
    }

    public void setUsingHTML(boolean usingHTML) {
        this.usingHTML = usingHTML;
    }

    public boolean isUsingHTML() {
        return this.usingHTML;
    }

    public boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Linux");
    }

    public void setCimom(boolean flag) {
        this.isCimom = flag;
    }

    public boolean isCimom() {
        return this.isCimom;
    }

    public void setManagerHost(String host) {
        this._host = host;
    }

    public InetAddress getManagerHost() throws UnknownHostException {
        return InetAddress.getByName(this._host);
    }

    public boolean isInstanceOf(Class derived, Class base) {
        boolean result = false;
        if (derived != null && base != null) {
            if (derived.equals(base)) {
                result = true;
            } else if (base.isInterface()) {
                Class<?>[] interfaces = derived.getInterfaces();
                int ix = 0;
                while (!result && ix < interfaces.length) {
                    result = this.isInstanceOf(interfaces[ix], base);
                    ++ix;
                }
            } else {
                result = this.isInstanceOf(derived.getSuperclass(), base);
            }
        }
        return result;
    }

    public byte[] hashPassword(String password) {
        MessageDigest digest = null;
        byte[] result = null;
        try {
            digest = MessageDigest.getInstance("SHA");
            result = digest.digest(new String(password).getBytes());
        }
        catch (NoSuchAlgorithmException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }
}

